const nodemailer = require('nodemailer');
const admin = require('firebase-admin');
const pool = require('../db');
const { createLeaveBalanceService } = require('../services/leaveBalances');
const { registerLeaveBalanceService, startReminderScheduler } = require('../reminders');

const mailer = nodemailer.createTransport({
  host: process.env.SMTP_HOST || 'smtp.gmail.com',
  port: Number(process.env.SMTP_PORT || 465),
  secure: process.env.SMTP_SECURE !== 'false',
  auth: {
    user: process.env.SMTP_USER,
    pass: process.env.SMTP_PASS,
  },
});

let adminSdk = null;
if (!admin.apps.length) {
  adminSdk = admin.initializeApp({
    credential: admin.credential.cert(require(`../${process.env.FCM_SERVICE_ACCOUNT_FILE}`)),
  });
}

const leaveBalanceService = createLeaveBalanceService(pool);
registerLeaveBalanceService(leaveBalanceService);

startReminderScheduler(pool, mailer, adminSdk, process.env.SMTP_FROM || 'ARU HR <no-reply@aru-hr.com>');
